* Poisson_fit2_gof.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Fitting the Poisson to frequency data';
data poisson;
	input y obsfreq;
	* Generate offset y values for plot;
	yexp = y - 0.1; yobs = y + 0.1;
	datalines;
0  24
1  16
2  16 
3  18
4  15
5   9
6   6
7   5
8   3
9   4
10  3
11  0
12  1
;
run;
* Print data set;
proc print data=poisson;
run;
* Descriptive statistics, save ybar, n, and var to data file;
proc univariate data=poisson;
	var y;
	histogram y / vscale=count;
	freq obsfreq;
	output out=stats mean=ybar n=n var=var;
run;
* Print output data file;
proc print data=stats;
run;
* Calculate expected frequencies using ybar;
data poisfit;
	if _n_ = 1 then set stats;
	set poisson;
	poisprob = pdf('poisson',y,ybar);
	expfreq = n*poisprob;
	* Calculate test values for each cell;
	cellchi2 = ((obsfreq - expfreq)**2)/expfreq;
	sumchi2 + cellchi2;
	olnoe = obsfreq*log(obsfreq/expfreq);
	sumlike + olnoe;
run;
* Print observed and expected frequencies;
proc print data=poisfit;
run;
* Plot observed and expected frequencies;
proc gplot data=poisfit;
	plot expfreq*yexp=1 obsfreq*yobs=2 / overlay legend=legend1 vref=0 wvref=3 
	vaxis=axis1 haxis=axis1;
	symbol1 i=needle v=circle c=red width=3 height=2;
	symbol2 i=needle v=square c=blue width=3 height=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	legend1 label=(height=2) value=(height=2);
run;
quit;
